/*

GUID

by EYJohn

*/

#include <stdio.h>
#include "version.h"
#include <q_shared.h>
#include <g_local.h>
#include <qmmapi.h>
#include <string.h>
#include <time.h>
#include "main.h"
#include <stdlib.h>
#include <stdarg.h>


//#include <windows.h>

pluginres_t* g_result = NULL;		//QMM result pointer

#ifndef NDEBUG
plugininfo_t g_plugininfo = {
	"bugfixes_debug",			//name of plugin
	"1.0.7b",		//version of plugin
	"Fixes Several Bugs in ET (20/11/2009 release)",	//description of plugin
	"Evgeny Yakimov",			//author of plugin
	"http://www.ycn-hosting.com",	//website of plugin
	1,				//can this plugin be paused?
	1,				//can this plugin be loaded via cmd
	1,				//can this plugin be unloaded via cmd
	QMM_PIFV_MAJOR,
	QMM_PIFV_MINOR
};
#else
plugininfo_t g_plugininfo = {
	"bugfixes",			//name of plugin
	"1.0.7b",		//version of plugin
	"Fixes Several Bugs in ET (20/11/2009 release)",	//description of plugin
	"Evgeny Yakimov",			//author of plugin
	"http://www.ycn-hosting.com",	//website of plugin
	0,				//can this plugin be paused?
	0,				//can this plugin be loaded via cmd
	1,				//can this plugin be unloaded via cmd
	QMM_PIFV_MAJOR,
	QMM_PIFV_MINOR
};
#endif

eng_syscall_t g_syscall = NULL;		//engine's syscall pointer
mod_vmMain_t g_vmMain = NULL;		//mod's vmMain pointer
int g_vmbase = 0;			//VM base address, used with GETPTR() macro
pluginfuncs_t* g_pluginfuncs = NULL;

char guids[MAX_CLIENTS][GUID_SIZE];
char ips[MAX_CLIENTS][IP_SIZE];
unsigned int lastchange[MAX_CLIENTS];
char changes[MAX_CLIENTS];

qboolean Valid_Guid(const char* guid);

//first function called in plugin, give QMM the plugin info
C_DLLEXPORT void QMM_Query(plugininfo_t** pinfo) {
	QMM_GIVE_PINFO();
}

//second function called, save pointers
C_DLLEXPORT int QMM_Attach(eng_syscall_t engfunc, mod_vmMain_t modfunc, pluginres_t* presult, pluginfuncs_t* pluginfuncs, int vmbase, int iscmd) {
	

	QMM_SAVE_VARS();
	iscmd = 0;			//ignore, but satisfy gcc -Wall
	g_syscall(G_PRINT, QMM_VARARGS("[bugfixes] %s v%s by %s\n", g_plugininfo.name, g_plugininfo.version, g_plugininfo.author));


	g_syscall(G_CVAR_REGISTER, NULL, "bf_userinfo",  "1", CVAR_ARCHIVE);
	g_syscall(G_CVAR_REGISTER, NULL, "bf_ws",  "1", CVAR_ARCHIVE);
	g_syscall(G_CVAR_REGISTER, NULL, "bf_teamchanges",  "3", CVAR_ARCHIVE);
	g_syscall(G_CVAR_REGISTER, NULL, "bf_callvote",  "1", CVAR_ARCHIVE);
	g_syscall(G_CVAR_REGISTER, NULL, "bf_maxcon",  "3", CVAR_ARCHIVE);

	return 1;
}

//last function called, clean up stuff allocated in QMM_Attach
C_DLLEXPORT void QMM_Detach(int iscmd) {
	iscmd = 0;			//ignore, but satisfy gcc -Wall
}

//called before mod's vmMain (engine->mod)
C_DLLEXPORT int QMM_vmMain(int cmd, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11) {

// Upon connect guid is stored, kicked for bad guids there 
// when change info if guid is diff, kick...
	if (cmd == GAME_CLIENT_CONNECT ) { 
		char userinfo[MAX_INFO_STRING];
		char guid[MAX_INFO_STRING];
		char ip[MAX_INFO_STRING];
		
		g_syscall(G_GET_USERINFO, arg0, userinfo, sizeof(userinfo)); // get from stored
		strncpy(guid,Info_ValueForKey(userinfo, "cl_guid"),sizeof(guid));
		strncpy(ip,Info_ValueForKey(userinfo, "ip"),sizeof(ip));
		
		// No IP specified, most likelly a flood, drop connection now
		if(ip[0]==NULL) {
			g_syscall(G_PRINT, QMM_VARARGS("bugfixes: removed client %d, invalid ip, possible flood\n",arg0));
			QMM_RET_SUPERCEDE((int) "You are connecting from an invalid IP address");
		}
		
		lastchange[arg0] = 0;
		changes[arg0] = 0;

		// We want it to save guids regardless if its on so it will
		// work if turned on later, but dont kick unless fix is on
		// Ignore the lan default guid
		if (strcmp(guid,"LaQ") != 0)
			strncpy(guids[arg0],guid,GUID_SIZE);
		// ip has no port for lan, but has port for inet, also no port for bots
		strncpy(ips[arg0],ip,IP_SIZE);
		
		// Remove Colon from IP if exists
		char * ipcolon;
		if ((ipcolon = strstr(ip,":"))!=NULL)
			ipcolon[0] = 0;
		int ip_len = strlen(ip);

		if (int max_connects = QMM_GETINTCVAR("bf_maxcon")) {
			int i;
			int x=0;
			int sv_maxclients = QMM_GETINTCVAR("sv_maxclients");
			for (i=0; i<sv_maxclients; ++i) {
				if (strncmp(ip,ips[i],ip_len)==0 && strncmp(ip,"localhost",ip_len)!=0) ++x; // ignore localhost
			}
			if (x>max_connects) {
				
				g_syscall(G_PRINT, QMM_VARARGS("bugfixes: removed client %d, too many connections from ip: %s\n",arg0,ip));	
				//g_syscall(G_SEND_CONSOLE_COMMAND,EXEC_APPEND,QMM_VARARGS("clientkick %d",arg0));
				//g_syscall(G_DROP_CLIENT,arg0,"There are too many connections from your ip");
				//g_syscall(G_DROP_CLIENT,arg0);
				QMM_RET_SUPERCEDE((int) "There are too many connections from your IP");
			}
		}

#ifndef NDEBUG
	} else if (cmd == GAME_CONSOLE_COMMAND) {
		int sv_maxclients = QMM_GETINTCVAR("sv_maxclients");
		int i=0;
		char command[10];
		g_syscall(G_ARGV, 0, command, sizeof(command));
		
		if (!strcasecmp(command,"who")){
			for (i=0; i<sv_maxclients; ++i) {
				g_syscall(G_PRINT, QMM_VARARGS("DEBUG: %d ip %s guid %s\n",i,ips[i],guids[i]));	
			}
		}
		QMM_RET_SUPERCEDE(1); // Ignore this call
		
#endif

	} else if (cmd == GAME_CLIENT_DISCONNECT) {
		guids[arg0][0]=0; // clear guid
		ips[arg0][0]=0; // clear ip
	
	} else if (cmd == GAME_CLIENT_USERINFO_CHANGED && QMM_GETINTCVAR("bf_userinfo")) { // need cvar checks too
		char userinfo[MAX_INFO_STRING];
		char guid[MAX_INFO_STRING];
		char ip[MAX_INFO_STRING];
		int invalid = 0;

		g_syscall(G_GET_USERINFO, arg0, userinfo, sizeof(userinfo)); // get from stored
		strncpy(guid,Info_ValueForKey(userinfo, "cl_guid"),sizeof(guid));
		strncpy(ip,Info_ValueForKey(userinfo, "ip"),sizeof(ip));

		if (guids[arg0][0] == 0) strncpy(guids[arg0],guid,GUID_SIZE);
		if (ips[arg0][0] == 0) strncpy(ips[arg0],ip,IP_SIZE);


		if (strncmp(guid,guids[arg0],GUID_SIZE)!=0) {
			Info_SetValueForKey(userinfo, "cl_guid", guids[arg0]);
			invalid = 1;
		}

		if (strncmp(ip,ips[arg0],IP_SIZE)!=0) {
			Info_SetValueForKey(userinfo, "ip", ips[arg0]);
			invalid = 1;
		}

		if (invalid) {

			g_syscall(G_SET_USERINFO, arg0, userinfo); // Restore Old GUID and IP
			/*
			g_syscall(G_PRINT, QMM_VARARGS("DEBUG, attempted infostring %s\n",userinfo));
			if (strncmp(guid,guids[arg0],GUID_SIZE)!=0)
				g_syscall(G_PRINT, QMM_VARARGS("DEBUG, GUID CHANGED %s to %s\n",guids[arg0],guid));
			if (strncmp(ip,ips[arg0],IP_SIZE)!=0)
				g_syscall(G_PRINT, QMM_VARARGS("DEBUG, _IP_ CHANGED %s to %s\n",ips[arg0],ip));
			*/
			QMM_RET_SUPERCEDE(1); // Ignore this call
		}
	} else if (cmd == GAME_CLIENT_COMMAND) {
	  
		char command[10];

		g_syscall(G_ARGV, 0, command, sizeof(command));
			

		if (QMM_GETINTCVAR("bf_ws") && !strcasecmp(command,"ws")){
			char argument[20];	
			g_syscall(G_ARGV, 1, argument, sizeof(argument));
			
			if (atoi(argument) > 1000 || atoi(argument) < 0) {
				g_syscall(G_PRINT, QMM_VARARGS("bugfixes: Client %d attempted to crash server with /ws\n",arg0));
				QMM_RET_SUPERCEDE(1);
			} else {
				QMM_RET_IGNORED(1);
			}
		}

		if (QMM_GETINTCVAR("bf_callvote") && !strcasecmp(command,"callvote")){
			int i = 0;
			int argcount = g_syscall(G_ARGC);
			char tmparg[1024];
			for (i=1; i<argcount; ++i) {
				g_syscall(G_ARGV, i, tmparg, sizeof(tmparg));
				if (strstr(tmparg,"\n") || strstr(tmparg,"\r")) {
					g_syscall(G_PRINT, QMM_VARARGS("bugfixes: Client %d attempted to exploit callvote bug with command:\n%s\n",arg0,tmparg));
					QMM_RET_SUPERCEDE(1);
				}
			}
			QMM_RET_IGNORED(1);
		}

		char maxchanges;
		if ((maxchanges = (char) QMM_GETINTCVAR("bf_teamchanges")) && !strcasecmp(command,"team")) {
			unsigned int curtime = g_syscall(G_MILLISECONDS);

			if (curtime - lastchange[arg0] <= 10000) {
				if (maxchanges <= changes[arg0]) {
					QMM_RET_SUPERCEDE(1);
				} else {
					lastchange[arg0] = curtime;
					++changes[arg0];
					QMM_RET_IGNORED(1);
				}
			} else {
				lastchange[arg0] = curtime;
				changes[arg0] = 1;
				QMM_RET_IGNORED(1);
			}
		}
	}
	
	QMM_RET_IGNORED(1);//we need GAME_CLIENT_COMMAND? yea
}

//called after mod's vmMain (engine->mod)
C_DLLEXPORT int QMM_vmMain_Post(int cmd, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11) {
	QMM_RET_IGNORED(1);
}

//called before engine's syscall (mod->engine)
C_DLLEXPORT int QMM_syscall(int cmd, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12) {

	QMM_RET_IGNORED(1);
}

//called after engine's syscall (mod->engine)
C_DLLEXPORT int QMM_syscall_Post(int cmd, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12) {
	QMM_RET_IGNORED(1);
}


qboolean Valid_Guid(const char* guid) {
	int i;
	if (strlen(guid) != 32)
		return qfalse; // not valid if over 32 char long
		
	for (i = 0 ; i < 32 ; ++i){
		if (guid[i] < 48 || ( guid[i] > 57 && guid[i] < 65) || guid[i] > 70)
			return qfalse; // if not a hex characternot valid if over 32 char long
	}
	return qtrue;
}


/*
=====================================================================

  INFO STRINGS

=====================================================================
*/

/*
===============
Info_ValueForKey

Searches the string for the given
key and returns the associated value, or an empty string.
FIXME: overflow check?
===============
*/
char *Info_ValueForKey( const char *s, const char *key ) {
	char	pkey[BIG_INFO_KEY];
	static	char value[2][BIG_INFO_VALUE];	// use two buffers so compares
											// work without stomping on each other
	static	int	valueindex = 0;
	char	*o;
	
	if ( !s || !key ) {
		return "";
	}

	if ( strlen( s ) >= BIG_INFO_STRING ) {
		g_syscall(G_PRINT, "[guid] ERROR: Info_ValueForKey: oversize infostring\n");
	}

	valueindex ^= 1;
	if (*s == '\\')
		s++;
	while (1)
	{
		o = pkey;
		while (*s != '\\')
		{
			if (!*s)
				return "";
			*o++ = *s++;
		}
		*o = 0;
		s++;

		o = value[valueindex];

		while (*s != '\\' && *s)
		{
			*o++ = *s++;
		}
		*o = 0;

		if (!strcasecmp (key, pkey) )
			return value[valueindex];

		if (!*s)
			break;
		s++;
	}

	return "";
}


/*
==================
Info_Validate

Some characters are illegal in info strings because they
can mess up the server's parsing
==================
*/
qboolean Info_Validate( const char *s ) {
	if ( strchr( s, '\"' ) ) {
		return qfalse;
	}
	if ( strchr( s, ';' ) ) {
		return qfalse;
	}
	return qtrue;
}

/*
==================
Info_SetValueForKey

Changes or adds a key/value pair
==================
*/

#ifdef WIN32
	#define snprintf _snprintf
#endif



void Info_SetValueForKey( char *s, const char *key, const char *value ) {
	char	newi[MAX_INFO_STRING];

	if ( strlen( s ) >= MAX_INFO_STRING ) {
		g_syscall(G_PRINT, "[guid] ERROR: Info_ValueForKey: oversize infostring\n");
	}

	if (strchr (key, '\\') || strchr (value, '\\'))
	{
		g_syscall(G_PRINT, "Can't use keys or values with a \\\n");
		return;
	}

	if (strchr (key, ';') || strchr (value, ';'))
	{
		g_syscall(G_PRINT, "Can't use keys or values with a semicolon\n");
		return;
	}

	if (strchr (key, '\"') || strchr (value, '\"'))
	{
		g_syscall(G_PRINT, "Can't use keys or values with a \"\n");
		return;
	}

	Info_RemoveKey (s, key);
	if (!value || !strlen(value))
		return;

	snprintf (newi, sizeof(newi), "\\%s\\%s", key, value); 

	if (strlen(newi) + strlen(s) > MAX_INFO_STRING)
	{
		g_syscall(G_PRINT, "Info string length exceeded\n");
		return;
	}

	strcat (s, newi);
}

/*
===================
Info_RemoveKey
===================
*/
void Info_RemoveKey( char *s, const char *key ) {
	char	*start;
	char	pkey[MAX_INFO_KEY];
	char	value[MAX_INFO_VALUE];
	char	*o;

	if ( strlen( s ) >= MAX_INFO_STRING ) {
		g_syscall(G_PRINT, "[guid] ERROR: Info_ValueForKey: oversize infostring\n");
	}

	if (strchr (key, '\\')) {
		return;
	}

	while (1)
	{
		start = s;
		if (*s == '\\')
			s++;
		o = pkey;
		while (*s != '\\')
		{
			if (!*s)
				return;
			*o++ = *s++;
		}
		*o = 0;
		s++;

		o = value;
		while (*s != '\\' && *s)
		{
			if (!*s)
				return;
			*o++ = *s++;
		}
		*o = 0;

		if (!strcasecmp (key, pkey) )
		{
			// rain - arguments to strcpy must not overlap
			//strcpy (start, s);	// remove this part
			memmove(start, s, strlen(s) + 1); // remove this part
			return;
		}

		if (!*s)
			return;
	}

}

//====================================================================


/*
==================
ConcatArgs - modified for QMM
==================
*/
   
char *QMM_ConcatArgs( int start ) {

	int		i, c, tlen;
	static char	line[MAX_STRING_CHARS];
	int		len;
	char	arg[MAX_STRING_CHARS];

	len = 0;
	c = g_syscall( G_ARGC );
	for ( i = start ; i < c ; i++ ) {
		g_syscall( G_ARGV, i, arg, sizeof( arg ) );
		tlen = strlen( arg );
		if ( len + tlen >= MAX_STRING_CHARS - 1 ) {
			break;
		}
		
		memcpy( line + len, arg, tlen );
		len += tlen;

		if ( i != c - 1 ) {
			line[len] = ' ';
			len++;
		}
	}
	line[len] = 0;
	return line;
}
