/******************************************************************************
Copyright (c) 2011, yada@#staatsschutz.org
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL yada@#staatsschutz.org BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

#include <stdio.h>
#include <stdint.h>
#include <string.h>

#define ETDED_SIZE	709216
#define OFS_PATCH1	(0x080B9BC0-0x08048000)
#define OFS_PATCH2	(0x080B9BE0-0x08048000)
#define OFS_PATCH3	(0x080564EF-0x08048000)
#define OFS_PATCH4	(0x08056507-0x08048000)
#define OFS_PATCH5	(0x08058C13-0x08048000)

#define PATCH(ofs,patch) \
	printf("Patching: %i bytes at offset %X.\n",sizeof(patch)-1,ofs); \
	memcpy(buf+(ofs),patch,sizeof(patch)-1)

int main(int argc, char** argv){
	char	patch1[]=				"\x6A\x08\x68\x08\x04\x00\x00\xB8\x14\x9E\x04\x08\xFF\xD0"
									"\xA3\xFC\x01\x88\x08\x83\xC4\x08\xC3";
	/*
									7EC09672  6A 08                   PUSH 8
									7EC09674  68 02040000             PUSH 402
									7EC09679  B8 149E0408             MOV EAX,8049E14
									7EC0967E  FFD0                    CALL EAX
									7EC09680  A3 FC018808             MOV DWORD PTR DS:[88801FC],EAX
									7EBF669E  83C4 08                 ADD ESP,8
									7EC09685  C3                      RETN
	*/
	char	patch2[]=				"\x8B\x84\x24\x48\x8C\x00\x00\x3D\x3C\x28\xF6\xC0\x74\x54"
									"\x3D\x01\x00\x00\x7F\x74\x4D\x60\xBB\x00\x0F\x00\x00\x8B"
									"\x3D\xA4\x4B\x87\x08\x8B\x35\xFC\x01\x88\x08\x33\xC9\x81"
									"\xF9\x00\x04\x00\x00\x74\x17\x8B\x54\xCE\x04\x85\xD2\x74" 
									"\x0F\x3B\xD0\x75\x08\x39\x7C\xCE\x08\x7D\x2C\xEB\x20\x41"
									"\xEB\xE1\x8B\x0E\x81\xF9\x00\x04\x00\x00\x75\x02\x33\xC9"
									"\x89\x44\xCE\x04\x03\xFB\x89\x7C\xCE\x08\x41\x89\x0E\x61"
									"\x33\xC0\xC3\x03\xFB\x89\x7C\xCE\x08\x61\x33\xC0\xC3\x61"
									"\x33\xC0\xB0\x01\xC3";
	/*
									7EBFF752  8B8424 488C0000        MOV EAX,DWORD PTR SS:[ESP+8C48]
									7EBFF759  3D 3C28F6C0            CMP EAX,C0F6283C
									7EBFF75E  74 54                  JE SHORT 7EBFF7B4
									7EBFF760  3D 0100007F            CMP EAX,7F000001
									7EBFF765  74 4D                  JE SHORT 7EBFF7B4
									7EBFF767  60                     PUSHAD
									7EBFF768  BB 000F0000            MOV EBX,0F00
									7EBFF76D  8B3D A44B8708          MOV EDI,DWORD PTR DS:[8874BA4]
									7EBFF773  8B35 FC018808          MOV ESI,DWORD PTR DS:[88801FC]
									7EBFF779  33C9                   XOR ECX,ECX
									7EBFF77B  81F9 00040000          CMP ECX,400
									7EBFF781  74 17                  JE SHORT 7EBFF79A
									7EBFF783  8B54CE 04              MOV EDX,DWORD PTR DS:[ESI+ECX*8+4]
									7EBFF787  85D2                   TEST EDX,EDX
									7EBFF789  74 0F                  JE SHORT 7EBFF79A
									7EBFF78B  3BD0                   CMP EDX,EAX
									7EBFF78D  75 08                  JNZ SHORT 7EBFF797
									7EBFF78F  397CCE 08              CMP DWORD PTR DS:[ESI+ECX*8+8],EDI
									7EBFF793  7D 2C                  JGE SHORT 7EBFF7C1
									7EBFF795  EB 20                  JMP SHORT 7EBFF7B7
									7EBFF797  41                     INC ECX
									7EBFF798  EB E1                  JMP SHORT 7EBFF77B
									7EBFF79A  8B0E                   MOV ECX,DWORD PTR DS:[ESI]
									7EBFF79C  81F9 00040000          CMP ECX,400
									7EBFF7A2  75 02                  JNZ SHORT 7EBFF7A6
									7EBFF7A4  33C9                   XOR ECX,ECX
									7EBFF7A6  8944CE 04              MOV DWORD PTR DS:[ESI+ECX*8+4],EAX
									7EBFF7AA  03FB                   ADD EDI,EBX
									7EBFF7AC  897CCE 08              MOV DWORD PTR DS:[ESI+ECX*8+8],EDI
									7EBFF7B0  41                     INC ECX
									7EBFF7B1  890E                   MOV DWORD PTR DS:[ESI],ECX
									7EBFF7B3  61                     POPAD
									7EBFF7B4  33C0                   XOR EAX,EAX
									7EBFF7B6  C3                     RETN
									7EBFF7B7  03FB                   ADD EDI,EBX
									7EBFF7B9  897CCE 08              MOV DWORD PTR DS:[ESI+ECX*8+8],EDI
									7EBFF7BD  61                     POPAD
									7EBFF7BE  33C0                   XOR EAX,EAX
									7EBFF7C0  C3                     RETN
									7EBFF7C1  61                     POPAD
									7EBFF7C2  33C0                   XOR EAX,EAX
									7EBFF7C4  B0 01                  MOV AL,1
									7EBFF7C6  C3                     RETN
	*/
	char 	patch3[]=	"\xB8\xC0\x9B\x0B\x08\xFF\xD0\x90\x90\x90\x90";
	/*								0032DF10  B8 C09B0B08			 MOV EAX,80B9BC0
									0032DF15  FFD0                   CALL EAX
									7EC0A674  90                     NOP
									7EC0A674  90                     NOP
									7EC0A674  90                     NOP
									7EC0A674  90                     NOP
	*/
	char 	patch4[]=	"\x90\x90\x90\x90\x90";
	/*								7EC0A674  90                     NOP
									7EC0A674  90                     NOP
									7EC0A674  90                     NOP
									7EC0A674  90                     NOP
									7EC0A674  90                     NOP
	*/
	FILE*	f;
	char	buf[ETDED_SIZE];
	
	printf(	"------------------------------------------------\n"
			"** limit getstatus patch 0.2 for etded.x86 2.60b\n"
			"           yada // staatsschutz.org // jan. 2011\n"
			"------------------------------------------------\n"
	);
	if(argc!=2){
		printf("Usage: %s [path-to-etded.x86]\n",argv[0]);
		return 1;
	}
	if(!(f=fopen(argv[1],"rb"))){
		printf("Error: Cannot open %s for reading.\n",argv[1]);
		return 1;
	}
	fseek(f,0,SEEK_END);
	if(ftell(f)!=ETDED_SIZE){
		printf("Error: Unknown etded version (size!=%i).\n",ETDED_SIZE);
		fclose(f);
		return 1;
	}
	fseek(f,0,SEEK_SET);
	fread(buf,ETDED_SIZE,1,f);
	fclose(f);
	
	PATCH(OFS_PATCH1,patch1);
	PATCH(OFS_PATCH2,patch2);
	PATCH(OFS_PATCH3,patch3);
	PATCH(OFS_PATCH4,patch4);
	printf("Patching: 4 bytes at offset %X.\n",OFS_PATCH5);
	*((int32_t*)(buf+OFS_PATCH5))=OFS_PATCH2-OFS_PATCH5-4;
	
	if(!(f=fopen(argv[1],"wb"))){
		printf("Error: Cannot open %s for writing.\n",argv[1]);
		return 1;
	}
	fwrite(buf,ETDED_SIZE,1,f);
	fclose(f);
	
	printf("Success: %s patched.\n",argv[1]);
	return 0;
}
